/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.history.BranchSelector;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DeleteBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(DeleteBranchAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>(info.getBranches());
        branches.remove(info.getActiveBranch().getName());
        if (branches.isEmpty()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DeleteBranchAction.class, (String)"MSG_DeleteBranchAction.noOtherBranches")));
            return;
        }
        BranchSelector selector = new BranchSelector(repository, branches);
        if (selector.open()) {
            this.deleteBranch(repository, selector.getSelectedBranch());
        }
    }

    public void deleteBranch(File repository, final String branchName) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteBranchAction.class, (String)"MSG_DeleteBranchAction.confirmation", (Object)branchName), NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.confirmation"), 2, 3);
        if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        boolean cont;
                        GitClient client = this.getClient();
                        boolean forceDelete = false;
                        do {
                            try {
                                LOG.log(Level.FINE, "Deleting a branch: {0}/{1}", new Object[]{branchName, forceDelete});
                                client.deleteBranch(branchName, forceDelete, this.getProgressMonitor());
                                cont = false;
                            }
                            catch (GitException.NotMergedException ex) {
                                cont = forceDelete = this.handleException(ex);
                            }
                        } while (cont);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private boolean handleException(GitException.NotMergedException ex) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteBranchAction.class, (String)"MSG_DeleteBranchAction.notMerged", (Object)ex.getUnmergedRevision()), NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.notMerged"), 0, 3);
                    return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.progressName", (Object)branchName));
        }
    }
}

